
# Fulfillment

Contains details about how to fulfill this order.
Orders can only be created with at most one fulfillment using the API.
However, orders returned by the Orders API might contain multiple fulfillments because sellers can create multiple fulfillments using Square products such as Square Online.

## Structure

`Fulfillment`

## Fields

| Name | Type | Tags | Description | Getter | Setter |
|  --- | --- | --- | --- | --- | --- |
| `uid` | `?string` | Optional | A unique ID that identifies the fulfillment only within this order.<br>**Constraints**: *Maximum Length*: `60` | getUid(): ?string | setUid(?string uid): void |
| `type` | [`?string (FulfillmentType)`](../../doc/models/fulfillment-type.md) | Optional | The type of fulfillment. | getType(): ?string | setType(?string type): void |
| `state` | [`?string (FulfillmentState)`](../../doc/models/fulfillment-state.md) | Optional | The current state of this fulfillment. | getState(): ?string | setState(?string state): void |
| `lineItemApplication` | [`?string (FulfillmentFulfillmentLineItemApplication)`](../../doc/models/fulfillment-fulfillment-line-item-application.md) | Optional | The `line_item_application` describes what order line items this fulfillment applies<br>to. It can be `ALL` or `ENTRY_LIST` with a supplied list of fulfillment entries. | getLineItemApplication(): ?string | setLineItemApplication(?string lineItemApplication): void |
| `entries` | [`?(FulfillmentFulfillmentEntry[])`](../../doc/models/fulfillment-fulfillment-entry.md) | Optional | A list of entries pertaining to the fulfillment of an order. Each entry must reference<br>a valid `uid` for an order line item in the `line_item_uid` field, as well as a `quantity` to<br>fulfill.<br><br>Multiple entries can reference the same line item `uid`, as long as the total quantity among<br>all fulfillment entries referencing a single line item does not exceed the quantity of the<br>order's line item itself.<br><br>An order cannot be marked as `COMPLETED` before all fulfillments are `COMPLETED`,<br>`CANCELED`, or `FAILED`. Fulfillments can be created and completed independently<br>before order completion. | getEntries(): ?array | setEntries(?array entries): void |
| `metadata` | `?array<string,string>` | Optional | Application-defined data attached to this fulfillment. Metadata fields are intended<br>to store descriptive references or associations with an entity in another system or store brief<br>information about the object. Square does not process this field; it only stores and returns it<br>in relevant API calls. Do not use metadata to store any sensitive information (such as personally<br>identifiable information or card details).<br><br>Keys written by applications must be 60 characters or less and must be in the character set<br>`[a-zA-Z0-9_-]`. Entries can also include metadata generated by Square. These keys are prefixed<br>with a namespace, separated from the key with a ':' character.<br><br>Values have a maximum length of 255 characters.<br><br>An application can have up to 10 entries per metadata field.<br><br>Entries written by applications are private and can only be read or modified by the same<br>application.<br><br>For more information, see [Metadata](https://developer.squareup.com/docs/build-basics/metadata). | getMetadata(): ?array | setMetadata(?array metadata): void |
| `pickupDetails` | [`?FulfillmentPickupDetails`](../../doc/models/fulfillment-pickup-details.md) | Optional | Contains details necessary to fulfill a pickup order. | getPickupDetails(): ?FulfillmentPickupDetails | setPickupDetails(?FulfillmentPickupDetails pickupDetails): void |
| `shipmentDetails` | [`?FulfillmentShipmentDetails`](../../doc/models/fulfillment-shipment-details.md) | Optional | Contains the details necessary to fulfill a shipment order. | getShipmentDetails(): ?FulfillmentShipmentDetails | setShipmentDetails(?FulfillmentShipmentDetails shipmentDetails): void |
| `deliveryDetails` | [`?FulfillmentDeliveryDetails`](../../doc/models/fulfillment-delivery-details.md) | Optional | Describes delivery details of an order fulfillment. | getDeliveryDetails(): ?FulfillmentDeliveryDetails | setDeliveryDetails(?FulfillmentDeliveryDetails deliveryDetails): void |

## Example (as JSON)

```json
{
  "uid": "uid0",
  "type": "DELIVERY",
  "state": "PREPARED",
  "line_item_application": "ALL",
  "entries": [
    {
      "uid": "uid5",
      "line_item_uid": "line_item_uid5",
      "quantity": "quantity1",
      "metadata": {
        "key0": "metadata8",
        "key1": "metadata9",
        "key2": "metadata0"
      }
    }
  ],
  "metadata": {
    "key0": "metadata3",
    "key1": "metadata4",
    "key2": "metadata5"
  },
  "pickup_details": {
    "recipient": {
      "customer_id": "customer_id8",
      "display_name": "display_name0",
      "email_address": "email_address8",
      "phone_number": "phone_number8",
      "address": {
        "address_line_1": "address_line_16",
        "address_line_2": "address_line_26",
        "address_line_3": "address_line_32",
        "locality": "locality6",
        "sublocality": "sublocality6",
        "sublocality_2": "sublocality_24",
        "sublocality_3": "sublocality_36",
        "administrative_district_level_1": "administrative_district_level_10",
        "administrative_district_level_2": "administrative_district_level_22",
        "administrative_district_level_3": "administrative_district_level_34",
        "postal_code": "postal_code8",
        "country": "TK",
        "first_name": "first_name6",
        "last_name": "last_name4"
      }
    },
    "expires_at": "expires_at2",
    "auto_complete_duration": "auto_complete_duration2",
    "schedule_type": "SCHEDULED",
    "pickup_at": "pickup_at6",
    "pickup_window_duration": "pickup_window_duration8",
    "prep_time_duration": "prep_time_duration0",
    "note": "note4",
    "placed_at": "placed_at2",
    "accepted_at": "accepted_at2",
    "rejected_at": "rejected_at0",
    "ready_at": "ready_at8",
    "expired_at": "expired_at8",
    "picked_up_at": "picked_up_at8",
    "canceled_at": "canceled_at4",
    "cancel_reason": "cancel_reason4",
    "is_curbside_pickup": false,
    "curbside_pickup_details": {
      "curbside_details": "curbside_details0",
      "buyer_arrived_at": "buyer_arrived_at6"
    }
  },
  "shipment_details": {
    "recipient": {
      "customer_id": "customer_id8",
      "display_name": "display_name0",
      "email_address": "email_address2",
      "phone_number": "phone_number2",
      "address": {
        "address_line_1": "address_line_16",
        "address_line_2": "address_line_26",
        "address_line_3": "address_line_32",
        "locality": "locality6",
        "sublocality": "sublocality6",
        "sublocality_2": "sublocality_24",
        "sublocality_3": "sublocality_36",
        "administrative_district_level_1": "administrative_district_level_10",
        "administrative_district_level_2": "administrative_district_level_22",
        "administrative_district_level_3": "administrative_district_level_34",
        "postal_code": "postal_code8",
        "country": "UA",
        "first_name": "first_name6",
        "last_name": "last_name4"
      }
    },
    "carrier": "carrier0",
    "shipping_note": "shipping_note4",
    "shipping_type": "shipping_type8",
    "tracking_number": "tracking_number6",
    "tracking_url": "tracking_url2",
    "placed_at": "placed_at2",
    "in_progress_at": "in_progress_at6",
    "packaged_at": "packaged_at2",
    "expected_shipped_at": "expected_shipped_at2",
    "shipped_at": "shipped_at6",
    "canceled_at": "canceled_at4",
    "cancel_reason": "cancel_reason6",
    "failed_at": "failed_at2",
    "failure_reason": "failure_reason2"
  },
  "delivery_details": {
    "recipient": {
      "customer_id": "customer_id6",
      "display_name": "display_name8",
      "email_address": "email_address6",
      "phone_number": "phone_number6",
      "address": {
        "address_line_1": "address_line_14",
        "address_line_2": "address_line_24",
        "address_line_3": "address_line_30",
        "locality": "locality4",
        "sublocality": "sublocality4",
        "sublocality_2": "sublocality_22",
        "sublocality_3": "sublocality_34",
        "administrative_district_level_1": "administrative_district_level_18",
        "administrative_district_level_2": "administrative_district_level_20",
        "administrative_district_level_3": "administrative_district_level_32",
        "postal_code": "postal_code6",
        "country": "AO",
        "first_name": "first_name4",
        "last_name": "last_name2"
      }
    },
    "schedule_type": "SCHEDULED",
    "placed_at": "placed_at4",
    "deliver_at": "deliver_at4",
    "prep_time_duration": "prep_time_duration8",
    "delivery_window_duration": "delivery_window_duration0",
    "note": "note2",
    "completed_at": "completed_at8",
    "in_progress_at": "in_progress_at8",
    "rejected_at": "rejected_at8",
    "ready_at": "ready_at6",
    "delivered_at": "delivered_at4",
    "canceled_at": "canceled_at2",
    "cancel_reason": "cancel_reason2",
    "courier_pickup_at": "courier_pickup_at2",
    "courier_pickup_window_duration": "courier_pickup_window_duration0",
    "is_no_contact_delivery": false,
    "dropoff_notes": "dropoff_notes0",
    "courier_provider_name": "courier_provider_name6",
    "courier_support_phone_number": "courier_support_phone_number2",
    "square_delivery_id": "square_delivery_id6",
    "external_delivery_id": "external_delivery_id0",
    "managed_delivery": false
  }
}
```

