
# Transaction

Represents a transaction processed with Square, either with the
Connect API or with Square Point of Sale.

The `tenders` field of this object lists all methods of payment used to pay in
the transaction.

## Structure

`Transaction`

## Fields

| Name | Type | Tags | Description | Getter | Setter |
|  --- | --- | --- | --- | --- | --- |
| `id` | `?string` | Optional | The transaction's unique ID, issued by Square payments servers.<br>**Constraints**: *Maximum Length*: `192` | getId(): ?string | setId(?string id): void |
| `locationId` | `?string` | Optional | The ID of the transaction's associated location.<br>**Constraints**: *Maximum Length*: `50` | getLocationId(): ?string | setLocationId(?string locationId): void |
| `createdAt` | `?string` | Optional | The timestamp for when the transaction was created, in RFC 3339 format.<br>**Constraints**: *Maximum Length*: `32` | getCreatedAt(): ?string | setCreatedAt(?string createdAt): void |
| `tenders` | [`?(Tender[])`](../../doc/models/tender.md) | Optional | The tenders used to pay in the transaction. | getTenders(): ?array | setTenders(?array tenders): void |
| `refunds` | [`?(Refund[])`](../../doc/models/refund.md) | Optional | Refunds that have been applied to any tender in the transaction. | getRefunds(): ?array | setRefunds(?array refunds): void |
| `referenceId` | `?string` | Optional | If the transaction was created with the [Charge](api-endpoint:Transactions-Charge)<br>endpoint, this value is the same as the value provided for the `reference_id`<br>parameter in the request to that endpoint. Otherwise, it is not set.<br>**Constraints**: *Maximum Length*: `40` | getReferenceId(): ?string | setReferenceId(?string referenceId): void |
| `product` | [`?string (TransactionProduct)`](../../doc/models/transaction-product.md) | Optional | Indicates the Square product used to process a transaction. | getProduct(): ?string | setProduct(?string product): void |
| `clientId` | `?string` | Optional | If the transaction was created in the Square Point of Sale app, this value<br>is the ID generated for the transaction by Square Point of Sale.<br><br>This ID has no relationship to the transaction's canonical `id`, which is<br>generated by Square's backend servers. This value is generated for bookkeeping<br>purposes, in case the transaction cannot immediately be completed (for example,<br>if the transaction is processed in offline mode).<br><br>It is not currently possible with the Connect API to perform a transaction<br>lookup by this value.<br>**Constraints**: *Maximum Length*: `192` | getClientId(): ?string | setClientId(?string clientId): void |
| `shippingAddress` | [`?Address`](../../doc/models/address.md) | Optional | Represents a postal address in a country.<br>For more information, see [Working with Addresses](https://developer.squareup.com/docs/build-basics/working-with-addresses). | getShippingAddress(): ?Address | setShippingAddress(?Address shippingAddress): void |
| `orderId` | `?string` | Optional | The order_id is an identifier for the order associated with this transaction, if any.<br>**Constraints**: *Maximum Length*: `192` | getOrderId(): ?string | setOrderId(?string orderId): void |

## Example (as JSON)

```json
{
  "id": "id0",
  "location_id": "location_id4",
  "created_at": "created_at2",
  "tenders": [
    {
      "id": "id2",
      "location_id": "location_id6",
      "transaction_id": "transaction_id0",
      "created_at": "created_at0",
      "note": "note8",
      "amount_money": {
        "amount": 214,
        "currency": "TJS"
      },
      "tip_money": {
        "amount": 218,
        "currency": "HTG"
      },
      "processing_fee_money": {},
      "customer_id": "customer_id0",
      "type": "OTHER",
      "card_details": {
        "status": "AUTHORIZED",
        "card": {
          "id": "id6",
          "card_brand": "INTERAC",
          "last_4": "last_48",
          "exp_month": 148,
          "exp_year": 148,
          "cardholder_name": "cardholder_name8",
          "billing_address": {
            "address_line_1": "address_line_18",
            "address_line_2": "address_line_22",
            "address_line_3": "address_line_38",
            "locality": "locality8",
            "sublocality": "sublocality2",
            "sublocality_2": "sublocality_20",
            "sublocality_3": "sublocality_38",
            "administrative_district_level_1": "administrative_district_level_16",
            "administrative_district_level_2": "administrative_district_level_22",
            "administrative_district_level_3": "administrative_district_level_30",
            "postal_code": "postal_code4",
            "country": "PY",
            "first_name": "first_name2",
            "last_name": "last_name0"
          },
          "fingerprint": "fingerprint2",
          "customer_id": "customer_id4",
          "merchant_id": "merchant_id6",
          "reference_id": "reference_id6",
          "enabled": false,
          "card_type": "DEBIT",
          "prepaid_type": "UNKNOWN_PREPAID_TYPE",
          "bin": "bin6",
          "version": 234,
          "card_co_brand": "UNKNOWN"
        },
        "entry_method": "KEYED"
      },
      "cash_details": {
        "buyer_tendered_money": {},
        "change_back_money": {}
      },
      "additional_recipients": [
        {
          "location_id": "location_id5",
          "description": "description1",
          "amount_money": {},
          "receivable_id": "receivable_id1"
        },
        {
          "location_id": "location_id6",
          "description": "description2",
          "amount_money": {},
          "receivable_id": "receivable_id2"
        },
        {
          "location_id": "location_id7",
          "description": "description3",
          "amount_money": {},
          "receivable_id": "receivable_id3"
        }
      ],
      "payment_id": "payment_id2"
    },
    {
      "id": "id3",
      "location_id": "location_id7",
      "transaction_id": "transaction_id1",
      "created_at": "created_at1",
      "note": "note9",
      "amount_money": {
        "amount": 215,
        "currency": "TMT"
      },
      "tip_money": {
        "amount": 219,
        "currency": "HUF"
      },
      "processing_fee_money": {},
      "customer_id": "customer_id1",
      "type": "CARD",
      "card_details": {
        "status": "FAILED",
        "card": {
          "id": "id5",
          "card_brand": "EFTPOS",
          "last_4": "last_47",
          "exp_month": 149,
          "exp_year": 147,
          "cardholder_name": "cardholder_name9",
          "billing_address": {
            "address_line_1": "address_line_17",
            "address_line_2": "address_line_23",
            "address_line_3": "address_line_39",
            "locality": "locality7",
            "sublocality": "sublocality3",
            "sublocality_2": "sublocality_21",
            "sublocality_3": "sublocality_37",
            "administrative_district_level_1": "administrative_district_level_17",
            "administrative_district_level_2": "administrative_district_level_21",
            "administrative_district_level_3": "administrative_district_level_31",
            "postal_code": "postal_code5",
            "country": "QA",
            "first_name": "first_name3",
            "last_name": "last_name1"
          },
          "fingerprint": "fingerprint1",
          "customer_id": "customer_id3",
          "merchant_id": "merchant_id5",
          "reference_id": "reference_id7",
          "enabled": true,
          "card_type": "UNKNOWN_CARD_TYPE",
          "prepaid_type": "PREPAID",
          "bin": "bin5",
          "version": 233,
          "card_co_brand": "AFTERPAY"
        },
        "entry_method": "EMV"
      },
      "cash_details": {
        "buyer_tendered_money": {},
        "change_back_money": {}
      },
      "additional_recipients": [
        {
          "location_id": "location_id6",
          "description": "description2",
          "amount_money": {},
          "receivable_id": "receivable_id2"
        }
      ],
      "payment_id": "payment_id3"
    },
    {
      "id": "id4",
      "location_id": "location_id8",
      "transaction_id": "transaction_id2",
      "created_at": "created_at2",
      "note": "note0",
      "amount_money": {
        "amount": 216,
        "currency": "TND"
      },
      "tip_money": {
        "amount": 220,
        "currency": "IDR"
      },
      "processing_fee_money": {},
      "customer_id": "customer_id2",
      "type": "CASH",
      "card_details": {
        "status": "VOIDED",
        "card": {
          "id": "id4",
          "card_brand": "FELICA",
          "last_4": "last_46",
          "exp_month": 150,
          "exp_year": 146,
          "cardholder_name": "cardholder_name0",
          "billing_address": {
            "address_line_1": "address_line_16",
            "address_line_2": "address_line_24",
            "address_line_3": "address_line_30",
            "locality": "locality6",
            "sublocality": "sublocality4",
            "sublocality_2": "sublocality_22",
            "sublocality_3": "sublocality_36",
            "administrative_district_level_1": "administrative_district_level_18",
            "administrative_district_level_2": "administrative_district_level_20",
            "administrative_district_level_3": "administrative_district_level_32",
            "postal_code": "postal_code6",
            "country": "RE",
            "first_name": "first_name4",
            "last_name": "last_name2"
          },
          "fingerprint": "fingerprint0",
          "customer_id": "customer_id2",
          "merchant_id": "merchant_id4",
          "reference_id": "reference_id8",
          "enabled": false,
          "card_type": "CREDIT",
          "prepaid_type": "NOT_PREPAID",
          "bin": "bin4",
          "version": 232,
          "card_co_brand": "CLEARPAY"
        },
        "entry_method": "ON_FILE"
      },
      "cash_details": {
        "buyer_tendered_money": {},
        "change_back_money": {}
      },
      "additional_recipients": [
        {
          "location_id": "location_id7",
          "description": "description3",
          "amount_money": {},
          "receivable_id": "receivable_id3"
        },
        {
          "location_id": "location_id8",
          "description": "description4",
          "amount_money": {},
          "receivable_id": "receivable_id4"
        }
      ],
      "payment_id": "payment_id4"
    }
  ],
  "refunds": [
    {
      "id": "id4",
      "location_id": "location_id8",
      "transaction_id": "transaction_id2",
      "tender_id": "tender_id2",
      "created_at": "created_at2",
      "reason": "reason0",
      "amount_money": {
        "amount": 186,
        "currency": "YER"
      },
      "status": "PENDING",
      "processing_fee_money": {
        "amount": 112,
        "currency": "GEL"
      },
      "additional_recipients": [
        {
          "location_id": "location_id7",
          "description": "description3",
          "amount_money": {},
          "receivable_id": "receivable_id3"
        }
      ]
    },
    {
      "id": "id5",
      "location_id": "location_id9",
      "transaction_id": "transaction_id3",
      "tender_id": "tender_id3",
      "created_at": "created_at3",
      "reason": "reason9",
      "amount_money": {
        "amount": 187,
        "currency": "ZAR"
      },
      "status": "APPROVED",
      "processing_fee_money": {
        "amount": 113,
        "currency": "GHS"
      },
      "additional_recipients": [
        {
          "location_id": "location_id8",
          "description": "description4",
          "amount_money": {},
          "receivable_id": "receivable_id4"
        },
        {
          "location_id": "location_id9",
          "description": "description5",
          "amount_money": {},
          "receivable_id": "receivable_id5"
        }
      ]
    },
    {
      "id": "id6",
      "location_id": "location_id0",
      "transaction_id": "transaction_id4",
      "tender_id": "tender_id4",
      "created_at": "created_at4",
      "reason": "reason8",
      "amount_money": {
        "amount": 188,
        "currency": "ZMK"
      },
      "status": "REJECTED",
      "processing_fee_money": {
        "amount": 114,
        "currency": "GIP"
      },
      "additional_recipients": [
        {
          "location_id": "location_id9",
          "description": "description5",
          "amount_money": {},
          "receivable_id": "receivable_id5"
        },
        {
          "location_id": "location_id0",
          "description": "description6",
          "amount_money": {},
          "receivable_id": "receivable_id6"
        },
        {
          "location_id": "location_id1",
          "description": "description7",
          "amount_money": {},
          "receivable_id": "receivable_id7"
        }
      ]
    }
  ],
  "reference_id": "reference_id2",
  "product": "PAYROLL",
  "client_id": "client_id8",
  "shipping_address": {
    "address_line_1": "address_line_10",
    "address_line_2": "address_line_20",
    "address_line_3": "address_line_36",
    "locality": "locality0",
    "sublocality": "sublocality0",
    "sublocality_2": "sublocality_28",
    "sublocality_3": "sublocality_30",
    "administrative_district_level_1": "administrative_district_level_14",
    "administrative_district_level_2": "administrative_district_level_26",
    "administrative_district_level_3": "administrative_district_level_38",
    "postal_code": "postal_code2",
    "country": "PT",
    "first_name": "first_name0",
    "last_name": "last_name8"
  },
  "order_id": "order_id6"
}
```

